#include <reg52.h>
#include <intrins.h> //_nop_()延时 一个机器周期 
#include "1602.h"
#include "delay_ms.h"
/*******************************************************************/
/*                                                                 */
/*检查LCD忙状态                                                    */
/*lcd_busy为1时，忙，等待。lcd-busy为0时,闲，可写指令与数据。      */
/*                                                                 */
/*******************************************************************/
 
bit lcd_busy()
{                          
    bit result;
    lcdrs = 0;
    lcdwr = 1;
    lcden = 1;
    _nop_();
    _nop_();
     result = (bit)(DATA&0x80);
    lcden = 0;
    return result; 
}
/*******************************************************************/
/*                                                                 */
/*写指令数据到LCD                                                  */
/*RS=L，RW=L，E=高脉冲，D0-D7=指令码。                             */
/*                                                                 */
/*******************************************************************/
void write_com(unsigned char com) //向液晶写命令 
{
	while(lcd_busy());
    lcdwr = 0;
	 lcdrs = 0;
    lcden = 0;
	 DATA = com;
	delay_ms(5);
    lcden = 1;
	delay_ms(5);
    lcden = 0;
}
/*******************************************************************/
/*                                                                 */
/*写显示数据到LCD                                                  */
/*RS=H，RW=L，E=高脉冲，D0-D7=数据。                               */
/*                                                                 */
/*******************************************************************/

void write_data(unsigned char date)//向液晶写一个数据 
{
	while(lcd_busy());
    lcdwr = 0;
  	 lcdrs = 1;
    lcden = 0;
  	 DATA = date;
	delay_ms(5);
    lcden = 1;
	delay_ms(5);
    lcden = 0;          
}

void write_1_char(unsigned char zifu)//写一个字符
{
	write_data(zifu);	
}
/*向液晶写n个字符*/
void write_n_char(unsigned char zifu[])//写N个字符
{
	unsigned char count;
	for(count=0; ;count++)
	{
		write_1_char(zifu[count]);
		if(zifu[count+1]=='\0')
		break;
	}
}
void lcd_pos(unsigned char x,unsigned char y) //设置液晶显示位置，x=0为第一行，1为第2行
{
	unsigned char pos;
	if(x == 0)
		x = 0x80;
	else if(x == 1)
		x = 0x80 + 0x40;
	pos = x + y;
	write_com(pos);
}
void yjinit()//液晶初始化 
{
    dula = 0;
    wela = 1;
    lcden = 0;
    write_com(0x38);//设置16x2显示，5x7点阵，8位数据口 
    write_com(0x0c);//设置开显示，不显示光标 
    write_com(0x06);//写一个字符后地址指针加1 
    write_com(0x01);//显示清0，数据指针清0        
}
