#include "nfc522.h"
#include "../MFRC522.H"

static const unsigned char DefaultKey[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

void NFC_Init(void) {
    PcdReset();
    PcdAntennaOff();
    PcdAntennaOn();
}

unsigned char NFC_VerifyCard(void) {
    unsigned char status;
    unsigned char buffer[18];
    
    status = PcdRequest(PICC_REQALL, buffer);
    if (status != MI_OK) return 0;
    
    status = PcdAnticoll(buffer);
    if (status != MI_OK) return 0;
    
    status = PcdSelect(buffer);
    if (status != MI_OK) return 0;
    
    status = PcdAuthState(PICC_AUTHENT1A, 1, (unsigned char*)DefaultKey, buffer);
    if (status != MI_OK) return 0;
    
    return 1;
}