#include "lpcreg.h"
#include "mfrc522.h"
#include <STDIO.H>
#include <string.h>
// #include <reg52.h>
#include "delay_ms.h"
#include  "KEY.h"
#include "i2c.h"
#include "1602.h"
#include "delay_ms.h"
#include "mima.h"
#include "main.h"
#define uchar unsigned char
#define uint unsigned int
#define A 0x0a //输入密码
#define B 0x0b  //修改密码
#define D 0x0d //关锁
#define enter 0x0c //确认
#define backspace 0x0f //退格键
sbit baojing = P3^7; //蜂鸣器接口
sbit lock = P3^3;//锁信号
sbit set = P3^2;
uchar idata mima_5[6] = {1,2,3,4,5,6}; //初始密码
uchar flag_change; 
uchar aa;//存放密码错误的次数，够三次报警
uchar bb;
uchar flag_t0;

unsigned char code data1[16] = {0x12,0x34,0x56,0x78,0xED,0xCB,0xA9,0x87,0x12,0x34,0x56,0x78,0x01,0xFE,0x01,0xFE};
//M1卡的某一块写为如下格式，则该块为钱包，可接收扣款和充值命令
//4字节金额（低字节在前）＋4字节金额取反＋4字节金额＋1字节块地址＋1字节块地址取反＋1字节块地址＋1字节块地址取反 
unsigned char code data2[4]  = {0,0,0,0x01};
unsigned char code DefaultKey[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
unsigned char code DefaultKey2[6] = {0x12, 0x34, 0x56, 0x78, 0x90, 0x12};
unsigned char g_ucTempbuf[20];

void delay1(unsigned int z)
{
	unsigned int x,y;
	for(x=z;x>0;x--)
	for(y=110;y>0;y--);	
}  

void InitializeSystem()
{
	P0M1 = 0x0; P0M2 = 0x0;
	P1M1 = 0x0;	P1M2 = 0x0;                      
	P3M1 = 0x04; P3M2 = 0x0B;
	P0 = 0xFF; P1 = 0xFF; P3 = 0xFF;P2 = 0xFF;

 	TMOD=0x21;		   //设T0为方式1，GATE=1；
	SCON=0x50;
	TH1=0xFa;          //波特率为4800bps
	TL1=0xFa;
	TH0=0;
	TL0=0; 
	TR0=1;  
	ET0=1;             //允许T0中断
	TR1=1;			   //开启定时器
	TI=1;
	EA=1;			   	//开启总中断
	
	ES = 1;
	RI = 1;

}

int RFID_Process(void) {
    unsigned char status, i, temp;

	status = PcdRequest(PICC_REQALL, g_ucTempbuf);  // 寻卡
	if (status != MI_OK) {
		// InitializeSystem();
		PcdReset();
		PcdAntennaOff();
		PcdAntennaOn();
		return 0;
	}
	
	printf("卡的类型:");
	for(i=0; i<2; i++) {
		temp = g_ucTempbuf[i];
		printf("%X", temp);
	}
	
	status = PcdAnticoll(g_ucTempbuf);  // 防冲撞
	if (status != MI_OK) return 0;
	
	printf("卡序列号：");
	for(i=0; i<4; i++) {
		temp = g_ucTempbuf[i];
		printf("%X", temp);
	}
	
	status = PcdSelect(g_ucTempbuf);  // 选定卡片
	if (status != MI_OK) return 0;
	
	status = PcdAuthState(PICC_AUTHENT1A, 1, DefaultKey, g_ucTempbuf);  // 验证卡片1密码
	if (status != MI_OK) return 0;

	status = PcdValue(PICC_DECREMENT, 1, data2);  // 扣款
	if (status != MI_OK) return 0;
	
	status = PcdBakValue(1, 2);  // 块备份
	if (status != MI_OK) return 0;
	
	status = PcdRead(2, g_ucTempbuf);  // 读块
	if (status != MI_OK) return 0;
	
	printf("卡读块：");
	for(i=0; i<16; i++) {
		temp = g_ucTempbuf[i];
		printf("%X", temp);
	}
	printf("\n");
	LED_GREEN = 0;
	delay1(100);
	LED_GREEN = 1;
	delay1(100);
	LED_GREEN = 0;
	delay1(200);
	LED_GREEN = 1;
	PcdHalt();
	return 1;
}

void baoj1()//报警函数
{
	int i;
	for(i = 0;i < 5; i++)
	{
		baojing = 0;
		delay_ms(5);
		baojing = 1;
		delay_ms(5);	
	}

}
void baoj()
{
	uchar i;
	for(i = 0; i < 10; i++)
		baoj1();
}
/*密码处理函数*/
void mimachuli() 
{
	uchar key,i;
	uchar idata mima_1[6]={' ',' ',' ',' ',' ',' '};//存放密码缓冲区
	uchar idata mima_2[6]={' ',' ',' ',' ',' ',' '};
	uchar idata mima_3[6]={' ',' ',' ',' ',' ',' '};

	key = step_choose();
	if(key == A)//A被按下,接收输入密码，处理
	{
    
		read_n_add(mima_1,0x00,6);
		write_com(0x06);//写一个字符后地址指针加 1 
		write_com(0x01);//显示清零，数据指针清零
		write_com(0x0f);//显示光标
		lcd_pos(0,0);
		write_n_char(" press password ");		
	
		if(input_mima(mima_2)) //处理输入密码
		{
			if(mimaduibi(mima_2,mima_1)) //密码正确
			{
				lcd_pos(0,0);
				write_com(0x0c);
	        	write_com(0x06);//写一个字符后地址指针加 1 
	         	write_com(0x01);//显示清零，数据指针清零
				write_n_char(" password right ");
				aa = 0; //清除密码错误次数
				lock = 0; //开锁
				baojing = 0; //响一下
				delay_ms(500);
				baojing = 1;
				TR0 = 1;    //打开定时器
				flag_t0 = 1;
				while(key != D && flag_t0) //D没按下或者时间还没到10s一直开
				{			
					key = keyscan();
				}
				TR0 = 0;
				lock = 1;//D按下了关锁
			}
			else //密码 不正确
			{
				lcd_pos(0,0);
				write_com(0x0c); //关光标
				write_com(0x06);//写一个字符后地址指针加 1 
				write_com(0x01);//显示清零，数据指针清零
				write_n_char(" password wrong");
				delay_ms(1000);
				aa++;
				if(aa == 4)
				{
					aa = 0;
			    	i = 20; //密码不正确报警
					while(i--)
					 baoj();
				}

			}
		}
		else //密码没有输入正确或完成
		{
			lcd_pos(0,0);
			write_com(0x0c); //关光标
	   	write_com(0x06);//写一个字符后地址指针加 1 
		   write_com(0x01);//显示清零，数据指针清零
			write_n_char(" password wrong");
			delay_ms(1000);
			aa++;
			if(aa == 4)
			{
				aa = 0;
		    	i = 20; //密码不正确报警
				while(i--)
				 baoj();
			}

		}
	}

	if(key == B)//B被按下,修改密码
	{
		read_n_add(mima_1,0x00,6);
		write_com(0x06);//写一个字符后地址指针加 1 
		write_com(0x01);//显示清零，数据指针清零
		write_com(0x0f);//显示光标
		lcd_pos(0,0);
		write_n_char("nfc card 5s");
		write_com(0x0f);//显示光标	
		for (i = 0; i < 200; i++)
		{
			switch (i)
			{
				case 40:
					write_com(0x06);//写一个字符后地址指针加 1 
					write_com(0x01);//显示清零，数据指针清零
					write_com(0x0f);//显示光标
					lcd_pos(0,0);
					write_n_char("nfc card 4s");
					break;
				case 80:
					write_com(0x06);//写一个字符后地址指针加 1 
					write_com(0x01);//显示清零，数据指针清零
					write_com(0x0f);//显示光标
					lcd_pos(0,0);
					write_n_char("nfc card 3s");
					break;
				case 120:
					write_com(0x06);//写一个字符后地址指针加 1 
					write_com(0x01);//显示清零，数据指针清零
					write_com(0x0f);//显示光标
					lcd_pos(0,0);
					write_n_char("nfc card 2s");
					break;
				case 160:
					write_com(0x06);//写一个字符后地址指针加 1 
					write_com(0x01);//显示清零，数据指针清零
					write_com(0x0f);//显示光标
					lcd_pos(0,0);
					write_n_char("nfc card 1s");
					break;
				default:
					break;
				}
			if(RFID_Process() == 1) {
				goto nfc_ok;
			}
		}
		write_com(0x06);//写一个字符后地址指针加 1 
		write_com(0x01);//显示清零，数据指针清零
		write_com(0x0f);//显示光标
		lcd_pos(0,0);
		write_n_char("Input password");
		if(input_mima(mima_2)) //处理输入密码
		{
			if(mimaduibi(mima_2,mima_1)) //密码正确
			{
				nfc_ok:
				lcd_pos(0,0);
				write_com(0x0c);
	      		write_com(0x06);//写一个字符后地址指针加 1 
	      		write_com(0x01);//显示清零，数据指针清零
				write_n_char("password right ");
				aa = 0; //清除密码错误次数
				delay_ms(1500);
				flag_change = 1;
				while(flag_change) //下面开始修改密码
				{
					write_com(0x06);//写一个字符后地址指针加 1 
					write_com(0x01);//显示清零，数据指针清零
					write_com(0x0f);//显示光标
					lcd_pos(0,0);
					write_n_char("In new password");
					delay_ms(1500);
					if(input_mima(mima_2)) //处理输入密码
					{

						lcd_pos(0,0);
						write_com(0x0c);
			         	write_com(0x06);//写一个字符后地址指针加 1 
			         	write_com(0x01);//显示清零，数据指针清零
						write_n_char("Input new pass"); //确定新密码
						lcd_pos(1,0);
						write_n_char("word again");
						delay_ms(2000);
						lcd_pos(0,0);
						write_com(0x0f);//显示光标
			         	write_com(0x06);//写一个字符后地址指针加 1 
			         	write_com(0x01);//显示清零，数据指针清零
						write_n_char("In new password");						
							if(input_mima(mima_3)) //处理输入密码
							{
								if(mimaduibi(mima_2,mima_3)) //密码正确
								{
									lcd_pos(0,0);
									write_com(0x0c);
						      		write_com(0x06);//写一个字符后地址指针加 1 
						      		write_com(0x01);//显示清零，数据指针清零
									write_n_char("password has");
									lcd_pos(1,0);
									write_n_char("change already");
									write_n_add(mima_3,0x00,6); //把修改的密码存进24C02
									delay_ms(2000);
									flag_change = 0;
								}
								else //密码 不正确
								{
									lcd_pos(0,0);
									write_com(0x0c); //关光标
									write_com(0x06);//写一个字符后地址指针加 1 
									write_com(0x01);//显示清零，数据指针清零
									write_n_char("password wrong");
									delay_ms(1000);
									aa++;
									if(aa == 4)
									{
										aa = 0;
								    	i = 20; //3次输入密码不正确报警
										while(i--)
										 baoj();
									}
									flag_change = 0;
								}
							}
							else //密码没有输入正确或完成
							{
								lcd_pos(0,0);
								write_com(0x0c); //关光标
						   		write_com(0x06);//写一个字符后地址指针加 1 
							   	write_com(0x01);//显示清零，数据指针清零
								write_n_char(" password wrong");
								delay_ms(1000);
								aa++;
								if(aa == 4)
								{
									aa = 0;
							    	i = 20; //3次输入密码不正确报警
									while(i--)
									 baoj();
								}
							}
						
					}
					else //密码没有输入正确或完成
					{
						lcd_pos(0,0);
						write_com(0x0c); //关光标
				   		write_com(0x06);//写一个字符后地址指针加 1 
					   	write_com(0x01);//显示清零，数据指针清零
						write_n_char("password wrong");
						delay_ms(1000);
						flag_change = 0;
						aa++;
						if(aa == 4)
						{
							aa = 0;
					    	i = 20; //3次输入密码不正确报警
							while(i--)
							 baoj();
						}
					}
									
				}
			}
			else //密码 不正确
			{
				lcd_pos(0,0);
				write_com(0x0c); //关光标
				write_com(0x06);//写一个字符后地址指针加 1 
				write_com(0x01);//显示清零，数据指针清零
				write_n_char("password wrong");
				delay_ms(1000);
				aa++;
				if(aa == 4)
				{
					aa = 0;
			    	i = 20; //3次输入密码不正确报警
					while(i--)
					 baoj();
				}
			}
		}
		else //密码没有输入正确或完成
		{
			lcd_pos(0,0);
			write_com(0x0c); //关光标
	   	write_com(0x06);//写一个字符后地址指针加 1 
		   write_com(0x01);//显示清零，数据指针清零
			write_n_char("password wrong");
			delay_ms(1000);
			aa++;
			if(aa == 4)
			{
				aa = 0;
		    	i = 20; //3次输入密码不正确报警
				while(i--)
				 baoj();
			}
		}		
	}

	if (key == N) //NFC认证成功
	{
		lcd_pos(0,0);
		write_com(0x0c);
		write_com(0x06);//写一个字符后地址指针加 1 
		write_com(0x01);//显示清零，数据指针清零
		write_n_char(" password right ");
		aa = 0; //清除密码错误次数
		lock = 0; //开锁
		baojing = 0; //响一下
		delay_ms(500);
		baojing = 1;
		TR0 = 1;    //打开定时器
		flag_t0 = 1;
		while(key != D && flag_t0) //D没按下或者时间还没到10s一直开
		{			
			key = keyscan();
		}
		TR0 = 0;
		lock = 1;//D按下了关锁
	}

}
 /*外部中断函数，恢复出厂设置,长按set键恢复*/

void int0() interrupt 0
{
	delay_ms(2000);
	if(!set)
	{
		lcd_pos(0,0);
		write_com(0x0c); //关光标
	   write_com(0x06);//写一个字符后地址指针加 1 
		write_com(0x01);//显示清零，数据指针清零
		i2cinit();//24C02总线初始化
		write_n_add(mima_5,0x00,6);
		write_n_char("password renew");
		lcd_pos(1,0);
		write_n_char("already");
		delay_ms(1000);
		lcd_pos(0,0);
		write_com(0x0c); //关光标
	   write_com(0x06);//写一个字符后地址指针加 1 
		write_com(0x01);//显示清零，数据指针清零
		write_n_char("Input password");
		lcd_pos(1,0);
		write_n_char("Press key A");

	}// 引起了三个警告
}

void timer0() interrupt 1 //定时器0中断,50ms定时
{
	TH0 = 0x4c;//50ms定时
	TL0 = 0x00;
	bb++;
	if(bb == 200)//10秒时间到
	{
		bb = 0;
		flag_t0 = 0;
	}

}
void main()
{
	PcdReset();
	PcdAntennaOff(); 
  	PcdAntennaOn(); 
	yjinit();//液晶初始化
	i2cinit();//24C02总线初始化
	baojing = 1;//关闭蜂鸣器
	lock = 1; //关锁
	TMOD = 0x01;//选择定时器0方式1
	EA = 1;//打开总中断
	ET0 = 1;//打开定时器0中断
	ET1 = 1;
	EX0 = 1; //打开外部中断0
	IT0 = 1;//下降沿触发
	IT1 = 1;//下降沿触发
	TR0 = 0;//关闭定时器
	TR1 = 1;
	TH0 = 0x4c;//50ms装初值
	TL0 = 0x00;
	TH1 = 0x4c;//50ms装初值
	TL1 = 0x00;
	ES = 1;
	RI = 1;
	while(1)
	{
		mimachuli(); 
	}
}



