#include <reg52.h>
#include "mima.h"
#include "1602.h"
#include "KEY.h"
#include "delay_ms.h"
#include "MAIN.h"

uchar t1;
uchar flag_t1 = 1;
/*比较密码函数，密码正确返回1，不正确返回0*/

bit mimaduibi(unsigned char *string1,unsigned char *string2)
{
	unsigned char count;
	for(count = 0; count < 6; count++)
	{
		if(string1[count] != string2[count])
		return 0;
	}
	return 1;
}

/*选择输入密码或修改密码函数，输入密码返回A，修改密码返回B*/

unsigned char step_choose(void)//选择输入密码或修改密码处理函数
{
	uchar key;
	key = 0xff;
	write_com(0x06);//写一个字符后地址指针加 1 
    write_com(0x01);//显示清零，数据指针清零
	lcd_pos(0,0);
	write_n_char(" Input password ");
	lcd_pos(1,0);
	write_n_char("  Press key A  ");	
	while(1) {
		key = keyscan();
		if(key == A || key == B || key == N) {
			break;  // 有有效按键时退出循环
		}
		
		if(RFID_Process() == 1) {
			key = 0x64;  // 定义RFID_SUCCESS为特定值
			break;  // RFID验证成功时退出循环
		}
	}
	return key;
}
/*输入密码函数，密码正确返回1，错误返回0*/

bit input_mima(uchar * mima)//输入密码函数
{
	unsigned char count,key;
	lcd_pos(1,0);
	for(count = 0; count < 7; count++)
	{

		delay_ms(100);
		if(count < 6)
		{
      
			do{key = keyscan();}//扫描键盘
			while(key == 0xff);
			if((key != backspace) && (key != A) && (key != enter))//不是退格也不是确认键
			{
				write_data('*');//是数字键显示*
				mima[count] = key;
			//	continue;
			}
			if(key == backspace)//是退格键
			{
				if(count > 0)
				{
				    lcd_pos(1,--count);//光标前移一位
					write_data(' ');//清空一位
					mima[count] = ' ';//写空
					lcd_pos(1,count);
					count--;//密码计数器减一 ,因为循环后会+1，所以在这里要加1
				}
			}
			if((key == enter) || (flag_t1==0))//没完成密码输入返回错误信息
			{
        TR1 = 0;
				lcd_pos(0,0);
				return(0);
			}
		}
		if(count==6)
		{
			do{key = keyscan();}
			while((key != backspace)&&(key != enter));
			if(key == backspace)
			{
				lcd_pos(1,--count);
				write_data(' ');
				mima[count]=' ';
				lcd_pos(1,count);
				count--;
			}
			if(key == enter)//密码位数正确
			{
				return(1);//返回1正确信号
			}
		}
	}	
}



void timer1() interrupt 3 //定时器0中断,50ms定时
{
	TH1 = 0x4c;//50ms定时
	TL1 = 0x00;
	t1++;
	if(t1 == 200)//10秒时间到
	{
		t1 = 0;
		flag_t1 = 0;
	}

}



